/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.world.chunk;

public class WorldChunk {
    public final int chunkX;
    public final int chunkY;
    public final int chunkZ;
    public final byte[] blocks;
    private final int[] lightDepths;

    public WorldChunk(int chunkX, int chunkY, int chunkZ) {
        this.chunkX = chunkX;
        this.chunkY = chunkY;
        this.chunkZ = chunkZ;
        this.blocks = new byte[4096];
        this.lightDepths = new int[256];
    }

    public int getBlock(int x, int y, int z) {
        return this.blocks[(y * 16 + z) * 16 + x] & 0xFF;
    }

    public void setBlock(int x, int y, int z, int type) {
        this.blocks[(y * 16 + z) * 16 + x] = (byte)type;
    }

    public int getLightDepth(int x, int z) {
        return this.lightDepths[x + z * 16];
    }

    public void setLightDepth(int x, int z, int depth) {
        this.lightDepths[x + z * 16] = depth;
    }
}

